DROP PROCEDURE [hips].[LevelTypeCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the LevelType Code Table
-- =============================================
CREATE PROCEDURE [hips].[LevelTypeCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@LevelTypeId INT = NULL
)
AS
BEGIN

	SELECT  lt.LevelTypeId, lt.Code, lt.Description
	FROM    hips.LevelTypeCode ltc
			JOIN hips.LevelType lt ON ltc.LevelTypeId = lt.LevelTypeId
			JOIN hips.CodeSystem cs ON ltc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (lt.LevelTypeId = @LevelTypeId OR @LevelTypeId IS NULL)
	ORDER BY lt.Description

END
GO

